#pragma once
#include "CodeInjector.h"
#include "RwV3d.h"

struct REVERSED RwSphere
{
	RwV3d center;
	float radius;
	RwSphere(float _x, float _y, float _z, float _r) :
		center(_x, _y, _z), radius(_r) { }
	RwSphere(const RwV3d& _c, float _r) :
		center(_c), radius(_r) { }
	RwSphere(const float *r) : center(r), radius(r[3]) { }
};

VALIDATE_SIZE(RwSphere, 16);