#####################################################################
#                                                                   #
#                  Makefile for CLEO 4 (GTA SA)                     #
#    Alien                                             10/16/2011   #
#                                                                   #
#####################################################################

include environment.mak

# Assume default configuration
ifeq ($(CONF), )
CONF=Debug # Release
endif

# Assume defualt output directory
ifeq ($(OUT_DIR), )
CONF=./$(CONF)/bin/
endif

# Output file
OUT_FILE:=$(OUT_DIR)cleo.asi
# Import library
IMP_LIB:=$(dir $(OUT_FILE))libcleo.a
# Definition file
DEF_FILE:=cleo.def

# C and C++ preprocessor definitions
DEFINES:=#_NTRACE

# Source files
CXX_SRC:=dllmain.cpp CleoInstance.cpp CodeInjector.cpp GameVersionManager.cpp CrtFix.cpp DmaFix.cpp \
	MenuStatusNotifier.cpp ScriptEngine.cpp crc32.cpp TextManager.cpp CustomOpcodeSystem.cpp \
	DebugLog.cpp SoundSystem.cpp

# Libraries
LIBS:=bass

# Include Directories
INC_DIRS:=./ ./rw/ ./GameObjects/ ./bass/inc/

# Library directories
LIB_DIRS:=./ ./bass/lib/

# GCC flags
CXX_FLAGS_Release:=-Os
CXX_FLAGS_Debug:=-g3 
CXX_FLAGS:=-std=c++0x -c -Wall -fno-rtti -save-temps=obj $(CXX_FLAGS_$(CONF)) $(addprefix -I,$(INC_DIRS)) $(addprefix -D,$(DEFINES))

# Linker's flags
LINK_FLAGS_Release:=-s
LINK_FLAGS_Debug:=
LINK_FLAGS:=-shared $(LINK_FLAGS_$(CONF)) $(addprefix -L,$(LIB_DIRS))

# Intermediate directory
OBJ_DIR:=./$(CONF)/obj/

# Object files
CXX_OBJ:=$(addprefix $(OBJ_DIR),$(CXX_SRC:.cpp=.o))

# Module dependencies
$(OBJ_DIR)dllmain.o : dllmain.cpp CleoInstance.h
$(OBJ_DIR)CleoInstance.o : CleoInstance.cpp CleoInstance.h CodeInjector.h DebugLog.h CrtFix.h DmaFix.h \
	ScriptEngine.h TextManager.h CustomOpcodeSystem.h SoundSystem.h PluginSystem.h
$(OBJ_DIR)CodeInjector.o : CodeInjector.cpp CodeInjector.h DebugLog.h
$(OBJ_DIR)GameVersionManager.o : GameVersionManager.cpp GameVersionManager.h DebugLog.h
$(OBJ_DIR)CrtFix.o : CrtFix.cpp CrtFix.h DebugLog.h CleoInstance.h CodeInjector.h GameVersionManager.h
$(OBJ_DIR)DmaFix.o : DmaFix.cpp DmaFix.h DebugLog.h CleoInstance.h CodeInjector.h GameVersionManager.h
$(OBJ_DIR)MenuStatusNotifier.o : MenuStatusNotifier.cpp MenuStatusNotifier.h DebugLog.h CodeInjector.h \
	./GameObjects/CMenuManager.h CleoInstance.h GameVersionManager.h ./rw/RwRect.h ./rw/RwRGBA.h
$(OBJ_DIR)ScriptEngine.o : ScriptEngine.cpp ScriptEngine.h DebugLog.h CleoInstance.h \
	CodeInjector.h GameVersionManager.h FileEnumerator.h ./GameObjects/CScriptThread.h crc32.h \
	 ./GameObjects/CMenuManager.h  CustomOpcodeSystem.h
$(OBJ_DIR)CustomOpcodeSystem.o : CustomOpcodeSystem.cpp CustomOpcodeSystem.h DebugLog.h CleoInstance.h \
	CodeInjector.h GameVersionManager.h ScriptEngine.h TextManager.h ./GameObjects/CPool.h
$(OBJ_DIR)TextManager.o : TextManager.cpp TextManager.h ./GameObjects/CText.h crc32.h DebugLog.h \
	CodeInjector.h FileEnumerator.h CleoInstance.h GameVersionManager.h
$(OBJ_DIR)SoundSystem.o : SoundSystem.cpp SoundSystem.h DebugLog.h CodeInjector.h CleoInstance.h \
	GameVersionManager.h
$(OBJ_DIR)DebugLog.o : DebugLog.cpp DebugLog.h

$(OBJ_DIR)crc32.o : crc32.cpp crc32.h

# Resource file
RES_FILE:=$(OBJ_DIR)res.o

# Resource script file
RC_FILE:=cleo4.rc

# build rules
$(OUT_FILE): $(CXX_OBJ) $(RES_FILE) $(DEF_FILE) | $(OUT_DIR).d
	@echo Linking... && $(CXX) $(LINK_FLAGS) $(CXX_OBJ) $(CC_OBJ) $(AS_OBJ) $(addprefix -l,$(LIBS)) $(RES_FILE) $(DEF_FILE) -o $(OUT_FILE) -Wl,--out-implib,$(IMP_LIB)

# build rule for C++ source files
$(CXX_OBJ): | $(OBJ_DIR).d
	@echo Compiling $@. Change list: $?  && $(CXX) $(CXX_FLAGS) -o $@ $(*F).cpp

# build rule for resource file
$(RES_FILE) : $(RC_FILE) | $(OBJ_DIR).d
	@echo Building resource... && $(WINDRES) -i $(RC_FILE) -o $(RES_FILE)

# rule for creating directory and its dependency file
%/.d:
	$(MKDIR) -p $(@D)
	$(TOUCH) $@

# external targets
build: $(OUT_FILE) 

clean:
	@echo Deleting object files... && $(RM) -rf $(CXX_OBJ)
	@echo Deleting resource... && $(RM) -rf $(RES_FILE)
	@echo Deleting asi... && $(RM) -rf $(OUT_FILE)
	