#pragma once
#include "CodeInjector.h"
#include <set>
#include "bass.h"
#include "RwV3d.h"
#include "CPlaceable.h"

namespace CLEO
{
	class CAudioStream; class C3dAudioStream;

	class SoundSystem : iInjectible
	{
		std::set<CAudioStream *> streams;
		bool initialized;
		int forceDevice;
		bool paused;
		HWND hwnd;
	public:
		virtual void inject(CodeInjector& inj);
		bool Init(HWND hwnd);
		SoundSystem(void);
		~SoundSystem(void);
		CAudioStream *LoadStream(const char *filename, bool in3d = false);
		void UnloadStream(CAudioStream *stream);
		void UnloadAllStreams();
		void Update();
	};

	class CAudioStream
	{
		friend class SoundSystem;
	protected:
		HSTREAM streamInternal;
		enum eStreamState
		{
			no,
			playing,
			paused,
			stopped,
		} state;
		bool OK;
		CAudioStream();
		CAudioStream(const CAudioStream&) = delete;
	public:
		CAudioStream(const char *src);
		virtual ~CAudioStream();
		// actions on streams
		void Play();
		void Pause(bool change_state = true);
		void Stop();
		void Resume();
		unsigned GetLength();
		unsigned GetState();
		float GetVolume();
		void SetVolume(float val);
		void Loop(bool enable);

		// overloadable actions
		virtual void Set3dPosition(const RwV3d& pos);
		virtual void Link(CPlaceable *placable = nullptr);
		virtual void Process();
	};

	class C3dAudioStream : public CAudioStream
	{
		friend class SoundSystem;
	protected:
		CPlaceable *link;
		C3dAudioStream(const C3dAudioStream&) = delete;
	public:
		C3dAudioStream(const char *src);
		virtual ~C3dAudioStream();
		// overloaded actions
		virtual void Set3dPosition(const RwV3d& pos);
		virtual void Link(CPlaceable *placable = nullptr);
		virtual void Process();
	};
}
