#pragma once
#include "CodeInjector.h"
#include "CScriptThread.h"
#include "CustomOpcodeSystem.h"
#include <list>
#include <set>

namespace CLEO
{
	const char cleo_dir[] = "./cleo";
	const char cs_mask[] = "./*.cs";
	
	class CCustomScript : public CScriptThread
	{
		friend class ScriptEngine;
		friend struct ThreadSavingInfo;
		unsigned long checksum;
		bool saving_enabled;
		bool OK;
		unsigned lastFoundActor, lastFoundVehicle, lastFoundObject;
	public:
		inline bool is_ok() { return OK; }
		inline void enable_saving(bool en = true) { saving_enabled = en; }
		inline unsigned& get_last_found_actor() { return lastFoundActor; }
		inline unsigned& get_last_found_vehicle() { return lastFoundVehicle; }
		inline unsigned& get_last_found_object() { return lastFoundObject; }
		CCustomScript(const char *filename, bool is_mission = false);
		~CCustomScript();
	};

	class ScriptEngine : iInjectible
	{
		friend class CCustomScript;
		std::list<CCustomScript *> customScripts;
		std::set<unsigned long> stoppedThreadHashes;
		CCustomScript *customMission;
	public:
		static SCRIPT_VAR CleoVariables[0x400];
		inline CCustomScript *custom_mission() { return customMission; }
		void LoadCustomScripts(bool load_mode = false);
		void SaveState();
		CCustomScript *FindThreadByName(const char *name);
		void AddCustomScript(CCustomScript *cs);
		void RemoveCustomScript(CCustomScript *cs);
		void RemoveAllCustomScripts();
		void UnregisterAllScripts();
		void ReregisterAllScripts();
		inline size_t WorkingScriptsCount() { return customScripts.size(); }
		virtual void inject(CodeInjector& inj);
		ScriptEngine();
		~ScriptEngine();
	};

	extern void THISCALL (* AddScriptToQueue)(CScriptThread *, CScriptThread **queue);
	extern void THISCALL(* RemoveScriptFromQueue)(CScriptThread *, CScriptThread **queue);
	extern void THISCALL(* StopScript)(CScriptThread *);
	extern char THISCALL(* ScriptOpcodeHandler00)(CScriptThread *, WORD opcode);
	extern void THISCALL (* GetScriptParams)(CScriptThread *, int count);
	extern void THISCALL (* TransmitScriptParams)(CScriptThread *, CScriptThread *);
	extern void THISCALL (* SetScriptParams)(CScriptThread *, int count);
	extern void THISCALL (* SetScriptCondResult)(CScriptThread *, bool);
	extern SCRIPT_VAR * THISCALL (* GetScriptParamPointer1)(CScriptThread *);
	extern void THISCALL (* GetScriptStringParam)(CScriptThread *, char* buf, BYTE len);
	extern SCRIPT_VAR * THISCALL (* GetScriptParamPointer2)(CScriptThread *, int __unused__);

	inline SCRIPT_VAR *GetScriptParamPointer(CScriptThread *thread) 
	{
		return GetScriptParamPointer2(thread, 0);
	}
	
	extern "C" {
		extern SCRIPT_VAR *opcodeParams;
		extern SCRIPT_VAR *missionLocals;
		extern CScriptThread *staticThreads;
	}
	
	extern BYTE *scmBlock, *missionBlock;
}
