#include "MenuStatusNotifier.h"
#include "CleoInstance.h"
#include "RwRect.h"
#include "RwRGBA.h"
#include <sstream>

namespace CLEO
{
	const char CLEO_VERSION_STR[] = "4.2a";

	void CDECL (* TextDraw)(float x,float y, const char* text);
	void CDECL (* SetTextAlign)(BYTE nAlign);
	void CDECL (* SetTextFont)(BYTE nFont);
	float THISCALL (* CMenuManager__ScaleX)(CMenuManager *, float w);
	float THISCALL (* CMenuManager__ScaleY)(CMenuManager *, float h);
	void CDECL (* SetLetterSize)(float w, float h);
	void CDECL (* SetLetterColor)(RwRGBA color);
	void THISCALL (*CTexture__DrawInRect)(void *texture, RwRect *rect, RwRGBA color);
	CMenuManager *menuManager;

	void THISCALL OnDrawMenuBackground(void *texture, RwRect *rect, RwRGBA color)
	{
		CTexture__DrawInRect(texture, rect, color);
		auto cs_count = GetThisInstance().scriptEngine.WorkingScriptsCount();
		std::ostringstream cleo_text;
		if (!cs_count)
			cleo_text << "CLEO v" << CLEO_VERSION_STR;
		else
			cleo_text << "CLEO (" << cs_count << (cs_count > 1 ? " working scripts)"
				: "working script)");
		SetTextAlign(1);
		SetTextFont(2);
		SetLetterSize(CMenuManager__ScaleX(menuManager, 0.20f), 
			CMenuManager__ScaleY(menuManager, 0.40f));
		SetLetterColor(RwRGBA(0xE1, 0xE1, 0xE1, 0xFF));
		TextDraw(CMenuManager__ScaleX(menuManager, 10.0f), 
			CMenuManager__ScaleY(menuManager, 435.0f), cleo_text.str().c_str());
	}

	void MenuStatusNotifier::inject(CodeInjector& inj)
	{
		TRACE("Injecting MenuStatusNotifier...");
		GameVersionManager& gvm = GetThisInstance().versionManager;
		menuManager = gvm.TranslateMemoryAddress(MA_MENU_MANAGER);		
		TextDraw = gvm.TranslateMemoryAddress(MA_DRAW_TEXT_FUNCTION);		
		SetTextAlign = gvm.TranslateMemoryAddress(MA_SET_TEXT_ALIGN_FUNCTION);
		SetTextFont = gvm.TranslateMemoryAddress(MA_SET_TEXT_FONT_FUNCTION);
		CMenuManager__ScaleX = gvm.TranslateMemoryAddress(MA_CMENU_SCALE_X_FUNCTION);
		CMenuManager__ScaleY = gvm.TranslateMemoryAddress(MA_CMENU_SCALE_Y_FUNCTION);
		SetLetterSize = gvm.TranslateMemoryAddress(MA_SET_LETTER_SIZE_FUNCTION);
		SetLetterColor = gvm.TranslateMemoryAddress(MA_SET_LETTER_COLOR_FUNCTION);
		CTexture__DrawInRect = gvm.TranslateMemoryAddress(MA_CTEXTURE_DRAW_IN_RECT_FUNCTION);		
		inj.ReplaceFunction(OnDrawMenuBackground, gvm.TranslateMemoryAddress(MA_CALL_CTEXTURE_DRAW_BG_RECT));
	}
}
