#include "DebugLog.h"
#include <windows.h>
#include <mutex>

const char log_file_name[] = "cleo.log";

DebugLog::DebugLog(void)
#ifndef _NTRACE
	: m_File(log_file_name)
#endif
{
#ifndef _NTRACE
	trace("Log started.");
#endif
}


DebugLog::~DebugLog(void)
{
#ifndef _NTRACE
	trace("Log finished.");
#endif
}

void DebugLog::trace(const char *fmt, ...)
{
#ifndef _NTRACE
	SYSTEMTIME	t;
	static char buffer[0x400];	// 1K
	static std::mutex mut;
	std::lock_guard<std::mutex> lock(mut);

	GetLocalTime (&t);
	sprintf(buffer, "%02d/%02d/%04d %02d:%02d:%02d.%03d ", t.wDay, 
		t.wMonth, t.wYear, t.wHour, t.wMinute, t.wSecond, t.wMilliseconds);
	va_list	arg;	
	va_start (arg, fmt);
	vsprintf (buffer + strlen(buffer), fmt, arg);
	va_end (arg);
	m_File << buffer << std::endl;
	OutputDebugString(buffer);
	OutputDebugString("\n");
#endif
}

DebugLog debug;

void Error(const char *message)
{
	MessageBox(nullptr, message, "CLEO error", MB_ICONERROR | MB_OK);
	TRACE("[Error] Exiting with error: %s", message);
	exit(1);
}

void Warning(const char *message)
{
	MessageBox(nullptr, message, "CLEO warning", MB_ICONWARNING | MB_OK);
	TRACE("[Warning] %s", message);
	exit(1);
}