#pragma once
#include "ScriptEngine.h"
#include "CodeInjector.h"
#include <set>
#include <windows.h>
#include <direct.h>

namespace CLEO
{
	enum OpcodeResult : char
	{
		OR_CONTINUE		= 0,
		OR_INTERRUPT	= 1
	};
	
	enum eOperandType
	{
		globalVar = 2,			
		localVar = 3,			
		globalArr = 7,
		localArr = 8,
		imm8 = 4,				
		imm16 = 5,				
		imm32 = 6,				
		imm32f = 1,				
		vstring = 0x0E,			
		sstring = 9,			
		globalVarVString = 0x10,
		localVarVString = 0x11,	
		globalVarSString = 0x0A,	
		localVarSString = 0x0B	
	};

	typedef OpcodeResult STDCALL (*CustomOpcodeHandler)(CScriptThread*);
	void ResetScmFunctionStore();

	class CustomOpcodeSystem : public iInjectible
	{
		friend OpcodeResult STDCALL opcode_0A9A(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0A9B(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0AA2(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0AA3(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0AC8(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0AC9(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0AE6(CScriptThread *thread);
		friend OpcodeResult STDCALL opcode_0AE8(CScriptThread *thread);
		std::set<FILE *> openedFiles;
		std::set<HMODULE> nativeLibs;
		std::set<HANDLE> fileSearches;
		std::set<void *> allocatedMemory;
	public:
		void FinalizeScriptObjects()
		{
			// clean up after opcode_0A99
			chdir("");
			TRACE("Finalizing script objects... %u files unclosed, %u libs unloaded, "
				"%u file searches unclosed...",
				openedFiles.size(), nativeLibs.size(), fileSearches.size());
			// clean up after opcode_0A9A
			std::for_each(openedFiles.begin(), openedFiles.end(), fclose);
			openedFiles.clear();
			// clean up after opcode_0AA2
			std::for_each(nativeLibs.begin(), nativeLibs.end(), FreeLibrary);
			nativeLibs.clear();
			//
			std::for_each(fileSearches.begin(), fileSearches.end(), FindClose);
			fileSearches.clear();
			// clean up agter opcode_0AB1
			ResetScmFunctionStore();
			// clean up agter opcode_0AC8
			std::for_each(allocatedMemory.begin(), allocatedMemory.end(), free);
		}
		virtual void inject(CodeInjector& inj);
		~CustomOpcodeSystem();
	};
}
