#include "CodeInjector.h"
#include "DebugLog.h"
#include <windows.h>
#include <algorithm>
#include <string>

namespace CLEO
{
	CodeInjector::CodeInjector(void)
		: access_opened(false)
	{
	}


	CodeInjector::~CodeInjector(void)
	{
	}

	void CodeInjector::OpenReadWriteAccess()
	{
		std::lock_guard<decltype(mut)> lock(mut);
		auto dwLoadOffset = static_cast<memory_pointer>(GetModuleHandle(nullptr));
		// Unprotect image - make .text and .rdata section writeable
		auto pImageBase = (BYTE *)dwLoadOffset;
		auto pDosHeader = (PIMAGE_DOS_HEADER)dwLoadOffset;
		auto pNtHeader  = (PIMAGE_NT_HEADERS)(pImageBase+pDosHeader->e_lfanew);
		auto pSection = IMAGE_FIRST_SECTION(pNtHeader);
		std::for_each(pSection, pSection + pNtHeader->FileHeader.NumberOfSections, 
			[=](IMAGE_SECTION_HEADER& section)
			{
				std::string section_name(reinterpret_cast<char *>(section.Name));
				if (section_name == ".text" || section_name == ".rdata")
				{
					DWORD dwPhysSize = (section.Misc.VirtualSize + 4095) & ~4095;    
					TRACE("Unprotecting section '%s': "
						"addr = 0x%08x, size = 0x%08x", section.Name, 
						(unsigned int)section.VirtualAddress, (unsigned int)dwPhysSize);
					DWORD oldProtect, newProtect = (section.Characteristics & IMAGE_SCN_MEM_EXECUTE) ? 
						PAGE_EXECUTE_READWRITE : PAGE_READWRITE;            
					if (!VirtualProtect(pImageBase + section.VirtualAddress, dwPhysSize, newProtect, &oldProtect)) 
						Error("Virtual protect error");
				}
			});
		access_opened = true;
	}

	void CodeInjector::CloseReadWriteAccess()
	{		
		std::lock_guard<decltype(mut)> lock(mut);
		auto dwLoadOffset = static_cast<memory_pointer>(GetModuleHandle(nullptr));
		auto pImageBase = (BYTE *)dwLoadOffset;
		auto pDosHeader = (PIMAGE_DOS_HEADER)dwLoadOffset;
		auto pNtHeader  = (PIMAGE_NT_HEADERS)(pImageBase+pDosHeader->e_lfanew);
		auto pSection = IMAGE_FIRST_SECTION(pNtHeader);
		std::for_each(pSection, pSection + pNtHeader->FileHeader.NumberOfSections, 
			[=](IMAGE_SECTION_HEADER& section)
			{
				std::string section_name(reinterpret_cast<char *>(section.Name));
				if (section_name == ".text" || section_name == ".rdata")
				{
					DWORD dwPhysSize = (section.Misc.VirtualSize + 4095) & ~4095;    
					TRACE("Reprotecting section '%s': "
						"addr = 0x%08x, size = 0x%08x", section.Name, 
						(unsigned int)section.VirtualAddress, (unsigned int)dwPhysSize);
					DWORD oldProtect, newProtect = (section.Characteristics & IMAGE_SCN_MEM_EXECUTE) ? 
						PAGE_EXECUTE_READ : PAGE_READONLY;            
					if (!VirtualProtect(pImageBase + section.VirtualAddress, dwPhysSize, newProtect, &oldProtect))
						Error("Virtual protect error");
				}
			});
		access_opened = false;
	}

	void CodeInjector::Nop(memory_pointer addr, size_t size)
	{
		const char nop_byte = 0x90;
		MemoryWrite(addr, nop_byte, true, size);
	}
}
