#include "CleoInstance.h"

namespace CLEO
{
	CleoInstance::CleoInstance(void)
		: started(false)
	{
	}


	CleoInstance::~CleoInstance(void)
	{
		stop();
	}

	void CDECL (*UpdateGameLogics)() = nullptr;

	void CDECL OnUpdateGameLogics()
	{
		UpdateGameLogics();
		GetThisInstance().soundSystem.Update();
	}

	void CleoInstance::start()
	{
		codeInjector.OpenReadWriteAccess();
		// replace function UpdateGameLogics in R* code
		UpdateGameLogics = versionManager.TranslateMemoryAddress(MA_UPDATE_GAME_LOGICS_FUNCTION);
		codeInjector.ReplaceFunction(OnUpdateGameLogics, versionManager.TranslateMemoryAddress(MA_CALL_UPDATE_GAME_LOGICS));
		crtFix.inject(codeInjector);
		dmaFix.inject(codeInjector);
		menuStatusNotifier.inject(codeInjector);
		scriptEngine.inject(codeInjector);
		opcodeSystem.inject(codeInjector);
		textManager.inject(codeInjector);
		soundSystem.inject(codeInjector);
		codeInjector.CloseReadWriteAccess();
		started = true;
	}

	void CleoInstance::stop()
	{
		if (!started) return;
	}

	CleoInstance cleoInstance;
	CleoInstance& GetThisInstance() { return cleoInstance; }
}
